/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// ./src/js/components/header.js
const hamburger = document.querySelector('.c-hamburger');

if (hamburger) {
	hamburger.addEventListener( "click", function(e) {
		e.preventDefault();

		if (e.target.classList.contains("is-active") === true) {
			closeMobMenu()
		}

		else {
			hamburger.classList.add("is-active");
			document.body.classList.add('menu-open')
		}
	});

	function closeMobMenu() {
		hamburger.classList.remove("is-active");
		document.body.classList.remove('menu-open')
	}
}
;// ./src/js/components/scrollbars.js
document.querySelectorAll('.scroll-styled').forEach(el => {
	const osInstance = OverlayScrollbars(el, {
		scrollbars: {
			autoHide: 'never',
			clickScroll: 'scroll',
			pointers: ['mouse', 'touch', 'pen'],
		},
		overflowBehavior: {
			x: 'hidden',
			y: 'scroll'
		}
	});



  const viewport = osInstance.elements().viewport; // один раз получили

  const btnUp = el.querySelector('.scroll-styled__control--up');
  const btnDown = el.querySelector('.scroll-styled__control--down');

  if (btnUp && btnDown) {
    btnUp.addEventListener('click', () => {
      viewport.scrollTo({ top: Math.max(viewport.scrollTop - 30, 0), behavior: 'smooth' });
    });

    btnDown.addEventListener('click', () => {
      const maxScrollTop = viewport.scrollHeight - viewport.clientHeight;
      viewport.scrollTo({ top: Math.min(viewport.scrollTop + 30, maxScrollTop), behavior: 'smooth' });
    });
  }
});

;// ./src/js/components/sliders.js
let swiperOne = document.querySelectorAll('.swiper-one');

if (swiperOne.length) {
	swiperOne.forEach(el => {
		new Swiper(el.querySelector('.swiper'), {
			spaceBetween: 8,
			navigation: {
				prevEl: el.querySelector('.swiper-button-prev'),
				nextEl: el.querySelector('.swiper-button-next'),
			},
		});
	});
}


let profileImages = document.querySelectorAll('.profile-images');

if (profileImages.length) {
	slideImages(profileImages)
}

let doctorPageDocs = document.querySelectorAll('.doctor-page__docs, .doctor-page__results, .doctor-page__video');

if (doctorPageDocs.length) {
	slideImages(doctorPageDocs)
}


function slideImages(items) {
	items.forEach(el => {
		new Swiper(el.querySelector('.swiper'), {
			spaceBetween: 8,
			slidesPerView: 'auto',
			navigation: {
				prevEl: el.querySelector('.swiper-button-prev'),
				nextEl: el.querySelector('.swiper-button-next'),
			},
			breakpoints: {
				992: {
					spaceBetween: 16,
				},
			}
		});
	});
}


let doctorVisit = document.querySelectorAll('.patients-page-visit');

if (doctorVisit.length) {
	doctorVisit.forEach(el => {
		new Swiper(el.querySelector('.swiper'), {
			spaceBetween: 8,
			slidesPerView: 'auto',
			navigation: {
				prevEl: el.querySelector('.swiper-button-prev'),
				nextEl: el.querySelector('.swiper-button-next'),
			}
		});
	});
}


let calendarSwipers = document.querySelectorAll('#cabinet-calendars .meeting-calendars__doctor');

if (calendarSwipers.length) {
	calendarSwipers.forEach(el => {console.log(el)
		new Swiper(el.querySelector('.swiper'), {
			spaceBetween: 8,
			navigation: {
				prevEl: el.querySelector('.swiper-button-prev'),
				nextEl: el.querySelector('.swiper-button-next'),
			},
			breakpoints: {
				992: {
					slidesPerView: 3,
					spaceBetween: 24,
				},
			}
		});
	});
}
;// ./src/js/components/forms.js
function bindTextInputEvents(container) {
	const inputs = container.querySelectorAll('.form-item-wrapper input:not([type="file"])');

	inputs.forEach(el => {
		// Проверка, чтобы не навешивать события повторно
		if (el.dataset.eventsBound) return;

		if (el.value.trim()) {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		}

		el.addEventListener('focus', () => {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		});

		el.addEventListener('blur', () => {
			if (!el.value.trim()) {
				el.closest('.form-item-wrapper').classList.remove('form-item-wrapper--active');
			}
		});

		el.dataset.eventsBound = 'true'; // пометка, что события уже навешаны
	});
}

function bindFileInputEvents(container) {
	const inputs = container.querySelectorAll('.form-item-wrapper--file input');

	inputs.forEach(el => {
		if (el.dataset.eventsBound) return;

		el.addEventListener('change', () => {
			const placeholder = el.closest('.form-item-wrapper--file').querySelector('.form-item-wrapper__placeholder');
			if (placeholder && el.files.length > 0) {
				placeholder.textContent = el.files[0].name;
			}
		});

		el.dataset.eventsBound = 'true';
	});
}


function bindSelectEvents(container) {
	const selects = container.querySelectorAll('.form-item-wrapper select');

	selects.forEach(el => {
		if (el.dataset.eventsBound) return;

		el.dataset.selectOpen = 'false';

		if (el.value.trim()) {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		}

		el.addEventListener('click', () => {
			const wrapper = el.closest('.form-item-wrapper');
			const isOpen = el.dataset.selectOpen === 'true';

			if (isOpen) {
				wrapper.classList.remove('form-item-wrapper--open');
				el.dataset.selectOpen = 'false';

				if (!el.value.trim()) {
					wrapper.classList.remove('form-item-wrapper--active');
				}
			}

			else {
				wrapper.classList.add('form-item-wrapper--open');
				wrapper.classList.add('form-item-wrapper--active');
				el.dataset.selectOpen = 'true';
			}
		});

		el.addEventListener('blur', () => {
			const wrapper = el.closest('.form-item-wrapper');
			wrapper.classList.remove('form-item-wrapper--open');
			el.dataset.selectOpen = 'false';

			if (!el.value.trim()) {
				wrapper.classList.remove('form-item-wrapper--active');
			}
		});

		el.dataset.eventsBound = 'true';
	});
}

bindTextInputEvents(document);
bindFileInputEvents(document);
bindSelectEvents(document);


let searchWithResults = document.querySelectorAll('.search-to-open__input');

if (searchWithResults.length) {
	searchWithResults.forEach(el => {
		let searchContainer = el.closest('.search-to-open');
		let searchResults = searchContainer.querySelector('.search-to-open__results');
		let items = Array.from(searchResults.children);

		el.addEventListener('input', function () {
			const query = el.value.trim().toLowerCase();

			if (query.length > 2) {
				let hasMatch = false;

				items.forEach(item => {
					const text = item.textContent.toLowerCase();

					if (text.includes(query)) {
						item.style.display = '';
						hasMatch = true;
					} 
					
					else {
						item.style.display = 'none';
					}
				});

				if (hasMatch) {
					showResults(searchResults);
				} 
				
				else {
					hideResults(searchResults);
				}
			} 
			
			else {
				items.forEach(item => item.style.display = '');
				hideResults(searchResults);
			}
		});

		el.addEventListener('blur', function () {
			hideResults(searchResults);
		});
	});

	function showResults(results) {
		results.style.height = results.scrollHeight + 'px';
	}

	function hideResults(results) {
		results.style.height = '';
	}
}

;// ./src/js/components/clone-items.js


let cloneBtns = document.querySelectorAll('.adding-item__clone');

if (cloneBtns.length) {
	cloneBtns.forEach(el => {
		el.addEventListener('click', function (e) {
			let clonedItem = e.target.closest('.adding-item').querySelector('.adding-item__body');
			let clone = clonedItem.cloneNode(true);

			clonedItem.parentNode.insertBefore(clone, clonedItem.nextSibling);
			const activeWrappers = clone.querySelectorAll('.form-item-wrapper--active');
			
			activeWrappers.forEach(el => el.classList.remove('form-item-wrapper--active'));

			const inputs = clone.querySelectorAll('input');
			inputs.forEach(input => {
				input.value = ''; // очистка значения

				if (input.id) {
					const baseId = input.id.split('-')[0];
					const suffix = '-' + randomString();
					const newId = baseId + suffix;

					input.id = newId;

					const label = clone.querySelector(`label[for="${baseId}"]`) || clone.querySelector(`label[for^="${baseId}-"]`);
					if (label) {
						label.setAttribute('for', newId);
					}
				}
			});

			clone.querySelectorAll('[data-events-bound]').forEach(el => {
				delete el.dataset.eventsBound;
			});

			bindTextInputEvents(document);
			bindFileInputEvents(document);
			bindSelectEvents(document);
		})
	});

	function randomString(length = 4) {
		const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
		return Array.from({ length }, () => chars[Math.floor(Math.random() * chars.length)]).join('');
	}
}


;// ./src/js/components/collapse.js
document.addEventListener('click', function(e) {
	if (e.target.closest('.collapse__btn')) {
		let el = e.target.closest('.collapse'), elContent = el.querySelector('.collapse__content');

		if (el.dataset.accordion) {
			accordion = document.querySelectorAll(`[data-accordion=${el.dataset.accordion}]`)
		}

		if (el.classList.contains('open')) {
			el.classList.remove('open');
			elContent.style.maxHeight = 0
		} else {
			if (el.dataset.accordion) {
				accordion.forEach(element => {
					element.classList.remove('open');
					element.querySelector('.collapse__content').style.maxHeight = 0;
				});
			}
			el.classList.add('open');
			elContent.style.maxHeight = elContent.scrollHeight + 'px'

			let $elParent = el.closest('.collapse__content') 

			if ($elParent) {
				setTimeout(() => {
					$elParent.style.maxHeight = $elParent.scrollHeight + 'px'
				}, 250)
			}
		}
	}	
})
;// ./src/js/components/fancyapps.js
if (document.querySelector("[data-fancybox]")) {
	Fancybox.bind("[data-fancybox]", {
		closeButton: false,
		Thumbs: false,
		// опция предотвращает ненужное пролистывание слайдера
		placeFocusBack: false,
	});
}
;// ./src/js/components/tabs.js
document.addEventListener('click', function(e) {
	if (e.target.closest('[data-tabs]')) {
		const $tab = e.target.closest('[data-tabs]');

		if (document.querySelector(`.active[data-tabs=${$tab.dataset.tabs}]`)) {
			document.querySelector(`.active[data-tabs=${$tab.dataset.tabs}]`).classList.remove('active')
		}
		if (document.querySelector(`.active[data-tabs-content=${$tab.dataset.tabs}]`)) {
			document.querySelector(`.active[data-tabs-content=${$tab.dataset.tabs}]`).classList.remove('active')
		}

		$tab.classList.add('active'); console.log($tab.dataset.tabTarget)
		document.getElementById($tab.dataset.tabTarget).classList.add('active')
	}	
})
;// ./src/js/main.js








/******/ })()
;
//# sourceMappingURL=main.js.map