import { Calendar } from '@fullcalendar/core';
import dayGridPlugin from '@fullcalendar/daygrid';
import ruLocale from '@fullcalendar/core/locales/ru';

const calendarDashboard = document.getElementById('dashboard-calendar');

if (calendarDashboard) {
	const calendar = new Calendar(calendarDashboard, {
		locale: ruLocale,
		plugins: [dayGridPlugin],
		initialView: 'dayGridMonth',
		headerToolbar: {
			start: 'prev',
			center: 'title',
			end: 'next'
		},
		height: 'auto',
		events: [
			{
				start: '2025-07-28',
				className: 'calendar-meeting-meed'
			},
			{
				start: '2025-07-29',
				className: 'calendar-meeting-good'
			},
			{
				start: '2025-07-30',
				className: 'calendar-meeting-bad'
			}
		]
	});

	calendar.render();
}


document.querySelectorAll('.cabinet-calendar').forEach(calEl => {
	const offset = parseInt(calEl.dataset.calendarOffset, 10);
	const date = new Date();
	date.setMonth(date.getMonth() + offset);

	const calendar = new Calendar(calEl, {
		locale: ruLocale,
		plugins: [dayGridPlugin],
		initialView: 'dayGridMonth',
		headerToolbar: {
			start: '',
			center: 'title',
			end: ''
		},
		height: 'auto',
		events: [
			{
				start: '2025-07-28',
				className: 'calendar-meeting-meed'
			},
			{
				start: '2025-07-29',
				className: 'calendar-meeting-good'
			},
			{
				start: '2025-07-30',
				className: 'calendar-meeting-bad'
			},
			{
				start: '2025-06-26',
				className: 'calendar-meeting-meed'
			},
			{
				start: '2025-06-23',
				className: 'calendar-meeting-good'
			},
			{
				start: '2025-06-12',
				className: 'calendar-meeting-bad'
			}
		]
	});

	setTimeout(() => {
		calendar.render();
		calendar.gotoDate(date);
	}, 200);
});

