import { bindTextInputEvents, bindFileInputEvents, bindSelectEvents } from './forms.js';

let cloneBtns = document.querySelectorAll('.adding-item__clone');

if (cloneBtns.length) {
	cloneBtns.forEach(el => {
		el.addEventListener('click', function (e) {
			let clonedItem = e.target.closest('.adding-item').querySelector('.adding-item__body');
			let clone = clonedItem.cloneNode(true);

			clonedItem.parentNode.insertBefore(clone, clonedItem.nextSibling);
			const activeWrappers = clone.querySelectorAll('.form-item-wrapper--active');
			
			activeWrappers.forEach(el => el.classList.remove('form-item-wrapper--active'));

			const inputs = clone.querySelectorAll('input');
			inputs.forEach(input => {
				input.value = ''; // очистка значения

				if (input.id) {
					const baseId = input.id.split('-')[0];
					const suffix = '-' + randomString();
					const newId = baseId + suffix;

					input.id = newId;

					const label = clone.querySelector(`label[for="${baseId}"]`) || clone.querySelector(`label[for^="${baseId}-"]`);
					if (label) {
						label.setAttribute('for', newId);
					}
				}
			});

			clone.querySelectorAll('[data-events-bound]').forEach(el => {
				delete el.dataset.eventsBound;
			});

			bindTextInputEvents(document);
			bindFileInputEvents(document);
			bindSelectEvents(document);
		})
	});

	function randomString(length = 4) {
		const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
		return Array.from({ length }, () => chars[Math.floor(Math.random() * chars.length)]).join('');
	}
}

