document.querySelectorAll('.scroll-styled').forEach(el => {
	const osInstance = OverlayScrollbars(el, {
		scrollbars: {
			autoHide: 'never',
			clickScroll: 'scroll',
			pointers: ['mouse', 'touch', 'pen'],
		},
		overflowBehavior: {
			x: 'hidden',
			y: 'scroll'
		}
	});



  const viewport = osInstance.elements().viewport; // один раз получили

  const btnUp = el.querySelector('.scroll-styled__control--up');
  const btnDown = el.querySelector('.scroll-styled__control--down');

  if (btnUp && btnDown) {
    btnUp.addEventListener('click', () => {
      viewport.scrollTo({ top: Math.max(viewport.scrollTop - 30, 0), behavior: 'smooth' });
    });

    btnDown.addEventListener('click', () => {
      const maxScrollTop = viewport.scrollHeight - viewport.clientHeight;
      viewport.scrollTo({ top: Math.min(viewport.scrollTop + 30, maxScrollTop), behavior: 'smooth' });
    });
  }
});
