import { fileURLToPath } from 'url';
import path from 'path';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

export default {
	mode: 'production',
	devtool: 'source-map',
	entry: {
		main: './src/js/main.js',
		calendar: './src/js/calendar.js', // добавлено
	},
	output: {
		filename: '[name].js', // будет main.js и calendar.js
		path: path.resolve(__dirname, 'dist/js/'),
	},
	optimization: {
		minimize: false,
	},
};